﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="BergBalanceScale.aspx.cs"
    Inherits="TBI_Instruments_BergBalanceScale" Title="" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server" ScriptMode="Release">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

            var _inactiveTimePeriod = <%=ConfigurationManager.AppSettings["AutoSaveInactiveInSeconds"] %>; // in seconds, set in web.config

            attachEvent(window, 'load', function () {
                var _inactivetimer = $find("<%=InactiveTimer.ClientID %>");
                var idleSeconds = _inactiveTimePeriod;
                var idleTimer;
                function resetTimer() {
                     _inactivetimer._stopTimer();
                     _inactivetimer.set_interval(idleSeconds*1000);
                     _inactivetimer._startTimer();
                     
                }
                attachEvent(document.body, 'mousemove', resetTimer);
                attachEvent(document.body, 'keydown', resetTimer);
                attachEvent(document.body, 'click', resetTimer);

                resetTimer(); // Start the timer when the page loads
            });

            function attachEvent(obj, evt, fnc, useCapture) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fnc, !!useCapture);
                    return true;
                }
                else if (obj.attachEvent) {
                    return obj.attachEvent("on" + evt, fnc);
                }
            }

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Berg Balance Scale"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="BBS" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding: 5px; width: 900px;">
                        <h2>
                            GENERAL INSTRUCTIONS</h2>
                        Please demonstrate each task and/or give instructions as written. When scoring, please record the lowest response category
                        that applies for each item.
                        <p>
                            In most items, the subject is asked to maintain a given position for specific time. Progressively more points are deducted
                            if the time or distance requirements are not met, if the subject's performance warrants supervision, or if the subject touches
                            an external support or receives assistance from the examiner. Subjects should understand that they must maintain their balance
                            while attempting the tasks. The choices of which leg to stand on or how far to reach are left to the subject. Poor judgment
                            will adversely influence the performance and the scoring.</p>
                        <p>
                            Equipment required for testing are a stopwatch or watch with a second hand, and a ruler or other indicator of 2, 5 and 10
                            inches (5, 12.5 and 25 cm). Chairs used during testing should be of reasonable height. Either a step or a stool (of average
                            step height) may be used for item #12.</p>
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <!-- Question Area -->
                    <table style="width: 100%;">
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 25px;">
                                
                            </td>
                            <td>
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="6">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="7">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="8" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 25px;">
                                
                            </td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 25px;">
                                1.
                            </td>
                            <td>
                                <!--Question 1: SITTING TO STANDING -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="17">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Please stand up. Try not to use your hands for support.</i><br />
                                <!-- Question 1 Choice List-->
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ1" TabIndex="18"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 1 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1" TabIndex="19" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 1 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 1 : Question Number-->
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                2.
                            </td>
                            <td>
                                <!--Question 2: STANDING UNSUPPORTED -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="20">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Please stand for two minutes without holding.</i><br />
                                <!-- Question 2 Choice List-->
                                <asp:RadioButtonList ID="rblQ2" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ2" TabIndex="21"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 2 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2" TabIndex="22" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 2 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 2 : Question Number-->
                                <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                3.
                            </td>
                            <td>
                                <!--Question 3: SITTING WITH BACK UNSUPPORTED BUT FEET SUPPORTED ON FLOOR OR ON A STOOL -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="rblQ3" SkinID="DataLabel" TabIndex="23">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Please sit with arms folded for 2 minutes.</i><br />
                                <!-- Question 3 Choice List-->
                                <asp:RadioButtonList ID="rblQ3" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ3" TabIndex="24"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 3 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="rblQ3" TabIndex="25" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 3 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ3" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ3" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 3 : Question Number-->
                                <asp:HiddenField ID="HiddenQ3" runat="server" Visible="false" Value="3" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                4.
                            </td>
                            <td>
                                <!--Question 4: STANDING TO SITTING -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="rblQ4" SkinID="DataLabel" TabIndex="26">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Please sit down.</i><br />
                                <!-- Question 4 Choice List-->
                                <asp:RadioButtonList ID="rblQ4" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ4" TabIndex="27"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 4 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="rblQ4" TabIndex="28" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 4 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ4" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ4" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 4 : Question Number-->
                                <asp:HiddenField ID="HiddenQ4" runat="server" Visible="false" Value="4" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                5.
                            </td>
                            <td>
                                <!--Question 5: TRANSFERS -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="rblQ5" SkinID="DataLabel" TabIndex="29">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Arrange chairs(s) for a pivot transfer. Ask subject to transfer one way toward a seat with armrests and one
                                    way toward a seat without armrests. You may use two chairs (one with and one without armrests) or a bed and a chair.</i><br />
                                <!-- Question 5 Choice List-->
                                <asp:RadioButtonList ID="rblQ5" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ5" TabIndex="30"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 5 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="rblQ5" TabIndex="31" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 5 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ5" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ5" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 5 : Question Number-->
                                <asp:HiddenField ID="HiddenQ5" runat="server" Visible="false" Value="5" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                6.
                            </td>
                            <td>
                                <!--Question 6: STANDING UNSUPPORTED WITH EYES CLOSED -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="rblQ6" SkinID="DataLabel" TabIndex="32">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Please close your eyes and stand still for 10 seconds.</i><br />
                                <!-- Question 6 Choice List-->
                                <asp:RadioButtonList ID="rblQ6" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ6" TabIndex="33"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 6 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="rblQ6" TabIndex="34" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 6 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ6" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ6" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 6 : Question Number-->
                                <asp:HiddenField ID="HiddenQ6" runat="server" Visible="false" Value="6" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                7.
                            </td>
                            <td>
                                <!--Question 7: STANDING UNSUPPORTED WITH FEET TOGETHER -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="35">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Place your feet together and stand without holding.</i><br />
                                <!-- Question 7 Choice List-->
                                <asp:RadioButtonList ID="rblQ7" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ7" TabIndex="36"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 7 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7" TabIndex="37" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 7 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 7 : Question Number-->
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                8.
                            </td>
                            <td>
                                <!--Question 8: REACHING FORWARD WITH OUTSTRETCHED ARM WHILE STANDING -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ8" runat="server" AssociatedControlID="rblQ8" SkinID="DataLabel" TabIndex="38">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Lift arm to 90 degrees. Stretch out your fingers and reach forward as far as you can. (Examiner places a ruler
                                    at end of fingertips when arm is at 90 degrees. Fingers should not touch the ruler while reaching forward. The recorded
                                    measure is the distance forward that the finger reach while the subject is in the most forward lean position. When possible,
                                    ask subject to use both arms when reaching to avoid rotation of the trunk.)</i><br />
                                <!-- Question 8 Choice List-->
                                <asp:RadioButtonList ID="rblQ8" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ8" TabIndex="39"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 8 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ8" runat="server" ControlToValidate="rblQ8" TabIndex="40" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 8 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ8" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ8" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 8 : Question Number-->
                                <asp:HiddenField ID="HiddenQ8" runat="server" Visible="false" Value="8" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                9.
                            </td>
                            <td>
                                <!--Question 9: PICK UP OBJECT FROM THE FLOOR FROM A STANDING POSITION -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ9" runat="server" AssociatedControlID="rblQ9" SkinID="DataLabel" TabIndex="41">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Pick up the shoe/slipper which is placed in front of your feet.</i><br />
                                <!-- Question 9 Choice List-->
                                <asp:RadioButtonList ID="rblQ9" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ9" TabIndex="42"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 9 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ9" runat="server" ControlToValidate="rblQ9" TabIndex="43" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 9 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ9" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ9" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 9 : Question Number-->
                                <asp:HiddenField ID="HiddenQ9" runat="server" Visible="false" Value="9" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                10.
                            </td>
                            <td>
                                <!--Question 10: TURNING TO LOOK BEHIND OVER LEFT AND RIGHT SHOULDERS WHILE STANDING -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ10" runat="server" AssociatedControlID="rblQ10" SkinID="DataLabel" TabIndex="44">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Turn to look <b>directly</b> behind you over toward left shoulder.<br />
                                    Repeat to the right.</i><br />
                                (Examiner may pick an object to look at directly behind the subject to encourage a better twist turn.)<br />
                                <!-- Question 10 Choice List-->
                                <asp:RadioButtonList ID="rblQ10" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ10" TabIndex="45"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 10 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ10" runat="server" ControlToValidate="rblQ10" TabIndex="46" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 10 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ10" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ10" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 10 : Question Number-->
                                <asp:HiddenField ID="HiddenQ10" runat="server" Visible="false" Value="10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                11.
                            </td>
                            <td>
                                <!--Question 11: TURN 360 DEGREES -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ11" runat="server" AssociatedControlID="rblQ11" SkinID="DataLabel" TabIndex="47">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Turn completely around in a full circle. Pause. Then turn a full circle in the other direction.</i><br />
                                <!-- Question 11 Choice List-->
                                <asp:RadioButtonList ID="rblQ11" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ11" TabIndex="48"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 11 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ11" runat="server" ControlToValidate="rblQ11" TabIndex="49" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 11 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ11" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ11" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 11 : Question Number-->
                                <asp:HiddenField ID="HiddenQ11" runat="server" Visible="false" Value="11" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                12.
                            </td>
                            <td>
                                <!--Question 12: PLACING ALTERNATE FOOT ON STEP OR STOOL WHILE STANDING UNSUPPORTED -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ12" runat="server" AssociatedControlID="rblQ12" SkinID="DataLabel" TabIndex="50">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Place each foot alternately on the step/stool. Continue until each foot has touched the step/stool four times.</i><br />
                                <!-- Question 12 Choice List-->
                                <asp:RadioButtonList ID="rblQ12" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ12" TabIndex="51"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 12 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ12" runat="server" ControlToValidate="rblQ12" TabIndex="52" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 12 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ12" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ12" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 12 : Question Number-->
                                <asp:HiddenField ID="HiddenQ12" runat="server" Visible="false" Value="12" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                13.
                            </td>
                            <td>
                                <!--Question 13: STANDING UNSUPPORTED ONE FOOT IN FRONT -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ13" runat="server" AssociatedControlID="rblQ13" SkinID="DataLabel" TabIndex="53">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: (DEMONSTRATE TO SUBJECT)</i><br />
                                Place one foot directly in front of the other. If you feel that you cannot place your foot directly in front, try to step
                                far enough ahead that the heel of your forward foot is ahead of the toes of the other foot. (To score 3 points, the length
                                of the step should exceed the length of the other foot and the width of the stance should approximate the subject's normal
                                stride width)
                                <br />
                                <!-- Question 13 Choice List-->
                                <asp:RadioButtonList ID="rblQ13" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ13" TabIndex="54"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 13 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ13" runat="server" ControlToValidate="rblQ13" TabIndex="55" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 13 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ13" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ13" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 13 : Question Number-->
                                <asp:HiddenField ID="HiddenQ13" runat="server" Visible="false" Value="13" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                                14.
                            </td>
                            <td>
                                <!--Question 14: STANDING ON ONE LEG -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ14" runat="server" AssociatedControlID="rblQ14" SkinID="DataLabel" TabIndex="56">
                                </asp:Label> <span class="requiredField">*</span><br />
                                <i>INSTRUCTIONS: Stand on one leg as long as you can without holding.</i><br />
                                <!-- Question 14 Choice List-->
                                <asp:RadioButtonList ID="rblQ14" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQ14" TabIndex="57"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question 14 Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ14" runat="server" ControlToValidate="rblQ14" TabIndex="58" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Selection is required."></asp:RequiredFieldValidator>
                                <!--Question 14 Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQ14" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ14" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question 14 : Question Number-->
                                <asp:HiddenField ID="HiddenQ14" runat="server" Visible="false" Value="14" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!--Question 15: Total -->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ15" runat="server" AssociatedControlID="rblQ14" SkinID="DataLabel" TabIndex="59">
                                </asp:Label> <asp:Button ID="btnCalculate" runat="server" Text="Calculate" OnClick="btnCalculate_Click" TabIndex="60" /><br /><br />
                                Total: <asp:Label ID="lblTotal" runat="server" Font-Bold="true" Text="0" TabIndex="61"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td>
                                <b>Interpretation</b><br/>
                                0–20, wheelchair bound<br/>
                                21–40, walking with assistance<br/>
                                41–56, independent
                            </td>
                        </tr>
                    </table>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="62" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="63" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="64" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
